<?php
/*
Plesk Sub & Domain Manager (Version see config.inc.php) - Extended Sub & Domain management for Parallels Plesk 7.x and higher

Copyright (C) [2006-2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

function getSite($s){
	 if($s == "") $s = "main";
	 return "./".$s.".php";
	 }
	 
function checkPrepared($dom){
         if(file_exists($dom."/conf/vhost.conf")) return true;
	 return false;
	 }
	 
function prepareDomain($dom){
         $toExec = "/usr/local/psa/admin/bin/websrvmng -u --vhost-name=".$dom;
	 $createVhost = str_replace("{DOMAIN}",$dom,DOCROOT)."conf/vhost.conf";
	 	 
         exec ('./wrapper "1" "0" "'.$createVhost.'"');
	 exec ($toExec);
	 }
	 
function getDocRoot($d,$s){
         $logFile = $d."/subdomains/".$s."/conf/vhost.conf";
         $fa = file($logFile);
	 if($fa[0] == "") return "/";
	 $str = str_replace("//","/",$fa[0]);
         $sp = strpos($str,"httpdocs/")+9;
         $str = substr($str,$sp);
	 return trim("/".$str);
        }

function getManVhost($l){
         $d = file($l);
         $r = "";
         for($i=0;$i<count($d);$i++){
             $r.=$d[$i];
             }
         return $r;
         }
	
function getMainDocRoot($d){
         $logFile = $d."/conf/vhost.conf";
	 $fa = file($logFile);
	 $str = "";
	 $found = false;
         for($r=0;$r<count($fa);$r++){
            if(eregi("DocumentRoot",$fa[$r])){
	       $str = $fa[$r];
	       $found = true;
	       }
	    }

         if($found){
 	    $str = str_replace("//","/",$str);
            $sp = strpos($str,"httpdocs/")+9;
            $str = substr($str,$sp);
	    }

	 return trim("/".$str);
         }

function getRootTree($i,$d,$s){
         $logFile = $d."/subdomains/".$s."/conf/vhost.conf";
         $fa = file($logFile);
	  $str = str_replace("//","/",$fa[0]);
         $str = str_replace("DocumentRoot ","",$str);

         if(eregi(trim($i),trim($str))) return "selected";
	  
	 return "";
        }
	 
function getForward($d,$s){

         $wwwroot = $d."subdomains/".$s."/httpdocs/";

         if(PSA_VERSION >= 10) $wwwroot = getPSA10SubDomPref($s,"www_root")."/";

	 if(file_exists($wwwroot."index.html.frf")){
            $logFile = $wwwroot."index.html";
  	    $fp = fopen ($logFile, "r");
	    $str = fread ($fp, filesize ($logFile)); 
            $re = '/FRAME SRC=([\'"])?(.*?)\\1/';
            preg_match($re, $str, $erg);
	    $str = $erg[2];
           }
         else{
           $logFile = $wwwroot.".htaccess";
 	   $fp = fopen ($logFile, "r");
	   $str = fread ($fp, filesize ($logFile)); 
	   if(!eregi("Redirect",$str)) return "http://";
	 
	   $str = str_replace("Redirect / ","",$str);
	   }
	   
	 return $str;
         }

function getSelected($d,$s){
         if($s == "") return "";            

         if(filesize($d."/subdomains/".$s."/conf/vhost.conf") > 10){
	    $ret = "document.subdom_edit.type[0].checked = true;\n";
	 
	      $ff = fopen ($d."subdomains/".$s."/conf/vhost.conf", "r");
   	      $strr = fread ($ff, filesize ($d."subdomains/".$s."/conf/vhost.conf")); 
	      
             if(eregi("AuthName",$strr)) $ret.= "document.subdom_edit.secure1.checked = true;\n";

	   return $ret;
	   }
	 
	 if(getForward($d,$s) != "http://"){
	   $ret = "document.subdom_edit.type[1].checked = true;";
	   
	   $wwwroot = $d."subdomains/".$s."/httpdocs/";
           if(PSA_VERSION >= 10) $wwwroot = getPSA10SubDomPref($s,"www_root")."/";
	   
	   if(file_exists($wwwroot."index.html.frf")){
	      $ret.=";document.subdom_edit.forward_type.selectedIndex = 1";
	     }
	   return $ret;
	   }
         
	 //return "document.subdom_edit.type[2].checked = true;";	 
	 }
	 
function getSelectedList($s,$d){

         if(filesize($d."/subdomains/".$s."/conf/vhost.conf") > 10) return TYPE_ROOT;
 
	 if(getForward($d,$s) != "http://") return TYPE_FORW;

         return TYPE_NO;
	 }


function holeUserListe($d,$s){
         
         if(!file_exists($d."subdomains/".$s."/httpdocs/.htpasswd")) return null;         

         $ret = array();
         $ff = file ($d."subdomains/".$s."/httpdocs/.htpasswd");
	  for($i=0;$i<count($ff);$i++){
            $uArr = explode(":",$ff[$i]);
            $ret[] = $uArr[0];
            }
	       
         return $ret;
         }

function holeAliasListe($d){
         
         if(!file_exists($d."conf/vhost.conf")) return null;         
         $ret = array();
         $ff = file ($d."conf/vhost.conf");
	  for($i=0;$i<count($ff);$i++){
             if(eregi("ServerAlias",$ff[$i]) && !eregi("www.",$ff[$i])){
                $uArr = explode(" ",$ff[$i]);
                $ret[] = $uArr[2];
               }
            }
	       
         return $ret;
         }
         
function getPSA10SubDomPref($sd,$pref){
         $sqldom = "SELECT $pref from subdomains where name='$sd' and dom_id='".$_GET["dom_id"]."'";
         $resultdom = mysql_query($sqldom);
	 $daten = mysql_fetch_array($resultdom);
         return $daten[$pref];
         }         
	 
function getPossAlias($cid){
         $sqldom = "SELECT name from domains where htype='none' and cl_id='".$cid."'";
	 echo $sqldom;
         $resultdom = mysql_query($sqldom);
	 while($daten = mysql_fetch_array($resultdom)){
	      $tArr[] = $daten["name"];
	      }
         return $tArr;
         }
	 
function checkAliases($a){
         $ff = file ("aliases.txt");
	  for($i=0;$i<count($ff);$i++){
             if(eregi($a,$ff[$i])) return "disabled";
            }

         return "";
         }
	 
function checkAliasesFor($a){
         $ff = file ("aliases.txt");
	 $ret = "";
	  for($i=0;$i<count($ff);$i++){
             if(eregi($a,$ff[$i])){
	        $r = explode("->",$ff[$i]);
		$ret = " -> ".$r[1];
		}
            }

         return $ret;
         }

function killAliases($a){
         $ff = file ("aliases.txt");
	  for($i=0;$i<count($ff);$i++){
             if(!eregi($a,$ff[$i])) $tmpStr.=$ff[$i];
            }
         $fp = fopen ("aliases.txt","w");
         $str = fwrite($fp,$tmpStr,strlen($tmpStr));
         fclose($fp);
         }

function checkVersion($v){
         $url = "http://www.haggybear.de/download/sudo.txt";
	 $p = fopen($url,"r");
	 $ver  = fgets($p,16);
	 fclose($fp);
	 
	 if($v != $ver) return "<a href=\"http://www.haggybear.de/download/sudo.zip\">".str_replace("{VER}",$ver,SUDO_VERSION_NOK)."</a>";
	 
	 return SUDO_VERSION_OK;
         }
	 
function getTdb($d){
         if(file_exists($d.TDB_PATH."/".TDB_BIN)) return true;
	 return false;
         }
	 
function getTdbCheck($d,$s){
         $ff = fopen ($d."subdomains/".$s."/conf/vhost.conf", "r");
   	 $strr = fread ($ff, filesize ($d."subdomains/".$s."/conf/vhost.conf")); 
	      
         if(eregi(TDB_BIN,$strr)) return "checked";
	 return "";
         }
	 
function getPhpCheck($d,$s){
         $ff = fopen ($d."subdomains/".$s."/conf/vhost.conf", "r");
   	 $strr = fread ($ff, filesize ($d."subdomains/".$s."/conf/vhost.conf")); 
	      
         if(eregi(PHP4MOD,$strr)) return true;
	 return false;
         }
	 
function getSslCheck($d,$s){
         $ff = fopen ($d."conf/vhost.conf", "r");
   	 $strr = fread ($ff, filesize ($d."conf/vhost.conf")); 
	 
         if(stristr($strr,'https')) return true;
	 return false;
         }	 


function getGlobalsCheck($d,$s){

         if($s != ""){
	    $ff = fopen ($d."subdomains/".$s."/conf/vhost.conf", "r");
       	    $strr = fread ($ff, filesize ($d."subdomains/".$s."/conf/vhost.conf")); 
	    }
	 else{
            $ff = fopen ($d."/conf/vhost.conf", "r");
       	    $strr = fread ($ff, filesize ($d."/conf/vhost.conf")); 
	    }

         if(eregi("register_globals 1",$strr)) return "checked";
	 return "";
         }

function getPhp5Check($d,$s){
         $ff = fopen ($d."subdomains/".$s."/conf/vhost.conf", "r");
   	 $strr = fread ($ff, filesize ($d."subdomains/".$s."/conf/vhost.conf")); 
	      
         if(eregi("php5-cgi",$strr)) return "checked";
	 return "";
         }


?>