<?php	
/*
Plesk Greylisting Manager (Version see version.php) - GUI for Plesk greylisting implementation by Parallels

Copyright (C) [2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
require("./paa.class.php");
require("./xtea.class.php");

class glm extends paa{


      var $versionUrl = "http://www.haggybear.de/download/glm";

      var $glmSettings = array();

      var $allPages = array("domain"=>"./main.php","overview"=>"./main.php","list"=>"./lists.php","plist"=>"./plists.php","admin"=>"./admin.php","update"=>"update.php");
      
      var $viewPage;
      
      var $glDates = array();
      
      var $domainId;

      var $queryString;      

      var $blockedCount = 0;

      var $passedCount = 0;

      var $prozentualValue = "0,00";

      var $mailQueue = array();
      
      var $allLists = array();

      var $allDoms;

      var $suchmuster = false;
      
      var $xtea;
      
      var $mailnames;
      
      var $userlists = array();
      
      var $userlistsCount;
      
      var $ul_status;

         function __construct($sess,$getVars,$db){
                 parent::paa($sess,$getVars["dom_name"],$db);
		 parent::openDatabase();
		 parent::setPleskSkin();
		 parent::setPleskAllowed();
		 $this->domainId = $getVars["dom_id"];
		 if(PSA_VERSION >= 10){
		    $this->domainId = $_SESSION["subscriptionId"]->current;
		    }
		 parent::setPleskAllowedDomains($getVars["cl_id"]);
		 parent::setOnlyAdm(false);
                 $this->allDoms = $this->getAllDomainsAndAliases();
                 $this->xtea = new XTEA(CRYPT_KEY);
		 $this->getMailnames();
		 $this->getUserLists();
                 }

        function __destruct(){
                 parent::closeDatabase();
                 }
 
        function setViewPage($vp){
                 $this->viewPage = (empty($vp))?"domain":$vp;
                 }

        function showDoms($zeit){
                 $retVal = MAILS_ALL;
                 if($this->viewPage == "domain") $retVal = implode(",",$this->allDoms); 
                 return $retVal.' [<a href="#" onClick="getPageContent(\'stat.php?zeit='.$zeit.'&overview='.$this->viewPage.'&'.$this->queryString.'\',\''.SERVER_STAT.'\',\'stat\')">'.SERVER_STAT.'</a>] - [<a href="javascript:doExport()">'.CSV_EXPORT.'</a>]';
                 }		
		 
	function getMailnames(){
		       $sql = "SELECT mail_name from mail where dom_id='".$this->domainId."'";
           $res = @mysql_query($sql);
           while($data = mysql_fetch_object($res)){
                 $this->mailnames[] = $data->mail_name;
		             }
	         }
	         
	      function setUserLists(){
	               $back = false;
	      	       if($_POST["addwl"] && !empty($_POST["wlentry"])){
	      	       	  $this->ul_status = (stristr($_POST["wlentry"],"@"))?'':'<span class="block">'.ERR_PLISTS.'</span>';
	      	       	  exec('/usr/local/psa/bin/grey_listing -um '.$_POST["mbox"].'@'.$this->allDoms[0].' -whitelist add:'.$_POST["wlentry"],$out);
			  $back = true;
	      	       	  }
	      	       if($_POST["addbl"] && !empty($_POST["blentry"])){
	      	       	  $this->ul_status = (stristr($_POST["blentry"],"@"))?'':'<span class="block">'.ERR_PLISTS.'</span>';
	      	       	  exec('/usr/local/psa/bin/grey_listing -um '.$_POST["mbox"].'@'.$this->allDoms[0].' -blacklist add:'.$_POST["blentry"],$out);
			  $back = true;
	      	       	  }
	      	       if(!empty($_GET["delwl"])){
	      	       	  exec('/usr/local/psa/bin/grey_listing -um '.$_GET["mbox"].'@'.$this->allDoms[0].' -whitelist del:'.urldecode($_GET["delwl"]));
			  $back = true;
	      	       	  }
	      	       if(!empty($_GET["delbl"])){
	      	       	  exec('/usr/local/psa/bin/grey_listing -um '.$_GET["mbox"].'@'.$this->allDoms[0].' -blacklist del:'.urldecode($_GET["delbl"]));
			  $back = true;
	      	       	  }
                       if($back)$this->getUserLists();
	      	       }
		 
        function getUserLists(){
	         $this->userlistsCount = array("white"=>0,"black"=>0);
	         $this->userlists = NULL;
	         for($i=0;$i<count($this->mailnames);$i++){
	         	   $out = array();
  	           exec('/usr/local/psa/bin/grey_listing -im '.$this->mailnames[$i].'@'.$this->allDoms[0],$out);
  	           $collect = "";
		           for($ii=0;$ii<count($out);$ii++){
		           	   if(stristr($out[$ii],"black")){
		           	   	  $collect = "black";
		           	   	  continue;
		           	   	  }
		           	   if(stristr($out[$ii],"white")){
		           	   	  $collect = "white";
		           	   	  
		           	   	  continue;
		           	   	  }
		           	   if(empty($out[$ii])){
		           	   	  $collect = "";
		           	   	  continue;
		           	   	  }
		           	   
		           	   if(!empty($collect)){
				          $this->userlistsCount[$collect]++;
		           	   	  $this->userlists[$this->mailnames[$i]][$collect][] = $out[$ii];
		           	   	  } 
		           	   	
		           	   
		           	   }
		           } 
	         }

	
	function greylistingProps($data){

                  $w = "";
                  if($this->viewPage == "domain"){
                     $w = "AND (rcptTo LIKE '%@".implode("' or rcptTo LIKE '%@",$this->allDoms)."')";
                     }
		  $dbh = new PDO('sqlite:'.DB_FILE_DATA);
		  $dates = array();
		  
                  foreach ($dbh->query("SELECT * FROM data ".ereg_replace("AND","WHERE",$w)." order by lastUpdate desc") as $row){
                          if(!$row["passCount"])$this->blockedCount+=($row["blockedCount"]+1);
                          $this->passedCount+=$row["passCount"];
			  $fDate = strtotime(date("d F Y",$row["lastUpdate"]));
			  if(!in_array($fDate ,$this->glDates)) $this->glDates[] = $fDate;
                          }
			  
                  if($data["filter"]=="pass") $w2.=" AND passCount>0";
                  if($data["filter"]=="block") $w2.=" AND passCount=0";
                  if($data["filter"]=="all") $w2 ="";

                  if($this->suchmuster){
                     $s.= " AND (remoteIP like '%".$this->suchmuster."%' or  mailFrom like '%".$this->suchmuster."%' or rcptTo like '%".$this->suchmuster."%')";
                     }

                  $w3 = ($data["limit"]=="ALL")?"":"LIMIT 0,".$data["limit"];
		  
		  if(empty($_POST["zeit"])) $_POST["zeit"] = $this->glDates[0];

		  if($_POST["zeit"] != "all"){
                     $myQry = "SELECT * FROM data WHERE (lastUpdate >= ".$_POST["zeit"]." and lastUpdate < ".($_POST["zeit"]+86400).") $w $w2 $s order by lastUpdate desc $w3"; 
		     }
                  else{
		     $myQry = str_replace("AND","WHERE","SELECT * FROM data $w $w2 $s order by lastUpdate desc $w3"); 
		  }

                  foreach ($dbh->query($myQry) as $row){
                           $this->mailQueue[] = $row;
                           }

                 $ps = $this->blockedCount / ($this->blockedCount+$this->passedCount) * 100;
	         $this->prozentualValue = str_replace(".",",",round($ps,2));
	         $this->greylistingList();
                 }

function printDates($aktTime){
         if(empty($aktTime)) $aktTime = $this->glDates[0];
         for($i=0;$i<count($this->glDates);$i++){
	     $sel = ($aktTime==$this->glDates[$i])?"selected":"";
	     echo '<option value="'.$this->glDates[$i].'" '.$sel.'>'.date(substr(TIME_SCHEME,0,5),$this->glDates[$i]).'</option>';
	     }
         $sel = ($aktTime=="all")?"selected":"";
         echo '<option value="all" '.$sel.'>'.SHOW_ALL.'</option>';


         }


        function greylistingUpdate($data,$what){
                  while (list($key, $val) = each($data)) {
                      if(eregi("kide_blfr_",$key)){
                         $pair = explode("#",$val);
                         if($what=="pass"){
                            $sql="UPDATE data set passCount=passCount+1 where creationTime='".$pair[0]."' and remoteIP='".$pair[1]."'";
                         }
                         else if ($what=="block"){
                            $sql="UPDATE data set passCount=0 where creationTime='".$pair[0]."' and remoteIP='".$pair[1]."'";
                         }
			 else if ($what=="kill"){
                            $sql="DELETE from data where creationTime='".$pair[0]."' and remoteIP='".$pair[1]."'";
                         }
			 else{
                         return;
                         }
                         exec('./wrapper "1" "'.DB_FILE_DATA.'" "'.$sql.'"');
                         }
                     }
                 }
                 
        function readAbuseSettings(){
                 $file = fopen("abuse.txt",'r');
                 $this->glmSettings["abuse"] = unserialize(trim(fread($file,filesize("abuse.txt"))));
                 fclose($file);
                 }
                 
        function readRemoteSettings(){
                 $file = fopen("remote.txt",'r');
                 $this->glmSettings["remote"] = unserialize(trim(fread($file,filesize("remote.txt"))));
                 fclose($file);
                 }
                 
        function schreibeAbuseSettings(){
                 $write = serialize($this->glmSettings["abuse"]);
                 $openStream = fopen ("abuse.txt","w");
                 fwrite($openStream,$write,strlen($write)); 
                 fclose($openStream);
                 }
                 
        function schreibeRemoteSettings(){
                 $write = serialize($this->glmSettings["remote"]);
                 $openStream = fopen ("remote.txt","w");
                 fwrite($openStream,$write,strlen($write)); 
                 fclose($openStream);
                 }

        function greylistingUpdateAdm($what){
                 if($what=="killall"){
                    $sql="DELETE FROM data";
                    }
                 else if($what=="cleanup"){
                    $delTs = (time() - ($this->glmSettings["expireInterval"]*60));
                    $sql="DELETE FROM data creationTime<'".$delTs."'";
                    }
                 else{
                   return;
                   }

                 exec('./wrapper "1" "'.DB_FILE_DATA.'" "'.$sql.'"');
                 }

        function greylistingList(){
		 $sql = "SELECT * from GL_remote_domains";
                 $res = @mysql_query($sql);
                 while($data = mysql_fetch_object($res)){
                      $this->allLists[$data->type][] = $data->domain;
		      }
                 }


        
         
        function getGreylistingTable(){
                 for($i=0;$i<count($this->mailQueue);$i++){

	             $className = "block";
        	     $titleName = PASS_FROM_NOW;
         	
         	     if($this->mailQueue[$i]["passCount"] > 0){
         	        $className = "pass";
         	        $titleName = CHECK_AGAIN;
         	        }
                
                     #echo "<tr id=\"row_".$data["id"]."\" onClick=\"getPageContent('ident.php?dieip=".mailQueue[$i]["passCount"]."&row=".$i."','".mailQueue[$i]["passCount"]."')\" class=\"handC ".$className."\" onMouseOver=\"markOver('".$i."')\" onMouseOut=\"markOut('".$i."')\">";
                     echo "<tr id=\"row_".$i."\" height=\"15\" class=\"handC ".$className."\" onMouseOver=\"markOver('".$i."')\" onMouseOut=\"markOut('".$i."')\">";
                     echo "<td title=\"".$this->mailQueue[$i]["remoteIP"]."\" id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" onMouseOver=\"toggleDirectList('".$i."_hlp_ip',1)\" onMouseOut=\"toggleDirectList('".$i."_hlp_ip',0)\"><div>".$this->highlight($this->mailQueue[$i]["remoteIP"])."</div><div id=\"".$i."_hlp_ip\" style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF;color:#000000;float:left\" class=\"invis\"><img src=\"help_ico.gif\" width=\"15\" height=\"15\" onClick=\"getPageContent('ident.php?dieip=".$this->mailQueue[$i]["remoteIP"]."&row=".$i."','".$this->mailQueue[$i]["remoteIP"]."','ip')\">&nbsp;<img src=\"wl.jpg\" width=\"12\" height=\"15\" onClick=\"setList('".$this->mailQueue[$i]["remoteIP"]."','w')\">&nbsp;<img src=\"bl.jpg\" width=\"12\" height=\"15\" onClick=\"setList('".$this->mailQueue[$i]["remoteIP"]."','b')\"></div></td>";
                     echo "<td title=\"".$this->mailQueue[$i]["mailFrom"]."\" id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" onMouseOver=\"toggleDirectList('".$i."_hlp_email',1)\" onMouseOut=\"toggleDirectList('".$i."_hlp_email',0)\"><div title=\"".$this->mailQueue[$i]["mailFrom"]."\" alt=\"".$this->mailQueue[$i]["mailFrom"]."\">".$this->highlight(substr($this->mailQueue[$i]["mailFrom"],0,40))."</div><div id=\"".$i."_hlp_email\" style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF;color:#000000;float:left\" class=\"invis\"><img src=\"help_ico.gif\" width=\"15\" height=\"15\" onClick=\"getPageContent('cm.php?addy=".$this->mailQueue[$i]["mailFrom"]."','".$this->mailQueue[$i]["mailFrom"]."','mail')\">&nbsp;<img src=\"wl_p.jpg\" width=\"12\" height=\"15\" onClick=\"setPList('".$this->mailQueue[$i]["mailFrom"]."','".$this->mailQueue[$i]["rcptTo"]."','w')\">&nbsp;<img src=\"bl_p.jpg\" width=\"12\" height=\"15\" onClick=\"setPList('".$this->mailQueue[$i]["mailFrom"]."','".$this->mailQueue[$i]["rcptTo"]."','b')\"></div></td>";
		     echo "<td title=\"".$this->mailQueue[$i]["rcptTo"]."\" id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" >".$this->highlight($this->mailQueue[$i]["rcptTo"])."</td>";
         	     echo "<td id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" >".($this->mailQueue[$i]["blockedCount"]+1)."</td>";
         	     echo "<td id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" >".$this->mailQueue[$i]["passCount"]."</td>";
          	     echo "<td title=\"".date(TIME_SCHEME,$this->mailQueue[$i]["creationTime"])."\" id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" >".date(TIME_SCHEME,$this->mailQueue[$i]["creationTime"])."</td>";
         	     echo "<td id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" >".date(TIME_SCHEME,$this->mailQueue[$i]["lastUpdate"])."</td>";
		     echo "<td id=\"".$i."\" onClick=\"toggleBox('row_'+this.id)\" >".date(TIME_SCHEME,$this->mailQueue[$i]["greyExpires"])."</td>";
         	     #echo "<td><div id=\"gfx\"><a href=\"?dom_name=".$like."&action=".$act."&".$className."=".$data[id]."\" alt=\"$titleName\" title=\"$titleName\"><img src=\"".$className.".gif\" width=\"15\" height=\"15\" border=\"0\"></a> <a href=\"?dom_name=".$like."&overview&kill=".$data[id]."\"><img src=\"kill.gif\" width=\"15\" height=\"15\" border=\"0\" alt=\"".DELETE."\" title=\"".DELETE."\"></a></div></td>";
         	     echo "<td align=\"center\"><input type=\"checkbox\" id=\"box_".$i."\" name=\"kide_blfr_".$className."_".$i."\" value=\"".$this->mailQueue[$i]["creationTime"]."#".$this->mailQueue[$i]["remoteIP"]."\" onClick=\"markSelected('this.checked','".$i."')\"\"></td>";
		     echo "</tr>";
         	
                    }


                 }

          function doExport(){
      	        $count = count($this->mailQueue);
      	        $sendStr = "";
      	        $sendStr = FROM_IP.",".FROM_MAIL.",".TO_MAIL.",".BLOCKED.",".PASSED.",".ENTRY_AT.",".LAST_UPDATE.",".str_replace("&auml;","ae",EXPIRES)."\n";
                for($i=0;$i<$count;$i++){
                    $sendStr.=strip_tags($this->mailQueue[$i]["remoteIP"]).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["mailFrom"]).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["rcptTo"]).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["blockedCount"]+1).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["passCount"]).",";
                    $sendStr.=date(TIME_SCHEME,$this->mailQueue[$i]["creationTime"]).",";
                    $sendStr.=date(TIME_SCHEME,$this->mailQueue[$i]["lastUpdate"]).",";
		    $sendStr.=date(TIME_SCHEME,$this->mailQueue[$i]["greyExpires"])."\n";
                    }  
               header ("Content-type: application/excel");
               header ("Content-Disposition: download; filename=GLM-export".date("d-m-y_H:i:s").".csv"); 
               echo $sendStr;
               exit;
      	       } 


	  function highlight($str){
                   if(!$this->suchmuster) return $str;

                   return str_replace($this->suchmuster,"<span class=\"highlight\">".$this->suchmuster."</span>",$str);
                   }
 
        function checkGLMPermissions(){

                 $sql = "SELECT * from GL_settings";
                 $res = @mysql_query($sql);
                 while($data = mysql_fetch_object($res)){
                      $this->glmSettings[$data->param] = $data->value;
		      }
                 if(!count($this->glmSettings)){
                    return '<br><div class="block">'.GLM_NO_GREYLISTING_SUPPORT.'</div><br>';
                   }
                 if(!$this->glmSettings["enabled"]){
                    return '<br><div class="block">'.GLM_GREYLISTING_NO_ACTIVE.'</div><br>';
                   }
                 return $this->allPages[$this->viewPage];

                 }

      function saveAdmin($data){
               while (list($key, $val) = each($data)) {
                      if(eregi("adm_",$key)){
                         $param = str_replace("adm_","",$key);
                         $value = $val;
                         $query = "UPDATE %s set value ='%s' where param ='%s'";
                         $qryMysql  = sprintf($query,'GL_settings',$value,$param); 
                         $qrySqlite = sprintf($query,'settings',(is_numeric($value))?($value*60):$value,$param);                      
                         exec('./wrapper "1" "'.DB_FILE_SETTINGS.'" "'.$qrySqlite.'"');
                         @mysql_query($qryMysql);
                         }
                     }  
		     
               $this->glmSettings["abuse"] = $data["spam-abuse"];
               if($this->glmSettings["remote"]["enabled"] != $data["remote-access"]["enabled"]){
	          $this->glmSettings["remote"]["enabled"] = $data["remote-access"]["enabled"];
		  }
	       
	       if($this->glmSettings["remote"]["admin"] != $data["remote-access"]["admin"]){
	       
	          if($data["remote-access"]["admin"] == "true"){
		     $this->glmSettings["remote"]["supertoken"] = $this->xtea->Encrypt(rand(1111111,9999999));
		     }
		  else{
		     unset($this->glmSettings["remote"]["supertoken"]);
		    }
	       
	          $this->glmSettings["remote"]["admin"] = $data["remote-access"]["admin"];
		  }
	       
               $this->schreibeAbuseSettings();
               $this->schreibeRemoteSettings();
               $this->checkGLMPermissions();
               }

      function checkVersion($v){
		$url = $this->versionUrl.".txt";
 	   	$p = fopen($url,"r");
	 	$ver  = fgets($p,16);
	 	fclose($p);

		if($this->plesk_session->chkLevel(IS_ADMIN) && AUTOUPDATE){
	           if($v != $ver){ 
 		      echo "<a href=\"?".$this->queryString."&action=update\">".str_replace("{VER}",$ver,GLM_VERSION_UPD)."</a>";
		      return;
		      }
	        }
	     
	 	if($v != $ver){
		   echo "<a href=\"".$this->versionUrl.".zip\">".str_replace("{VER}",$ver,GLM_VERSION_NOK)."</a>";
		   return;
		   }
	 
	 	echo GLM_VERSION_OK;
        	}

     function setQueryString($qs){
            	$expr = '/statmessage=(.*)&/i';
		$qs = preg_replace($expr, '', $qs);
		$expr = '/&todo=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
		$expr = '/&admin=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
                $expr = '/&action=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
        	$this->queryString = $qs;
              }

     function getQueryString(){
              echo $this->queryString;
              }

     function getAllDomainsAndAliases(){
	
	         $doms[] = $this->plesk_domain;



	         $hasDomAlias = false;
	       
	         if(mysql_num_rows(mysql_query("SHOW TABLES LIKE 'domainaliases'"))>0) $hasDomAlias = true;
                 $result = mysql_query("SELECT a.id, a.name, b.id FROM psa.domainaliases AS a, psa.domains AS b WHERE b.name = '".$this->plesk_domain."' AND b.id = a.dom_id");
                 if($result && $hasDomAlias){
                    while($data = mysql_fetch_object($result)){
                          $doms[] = $data->name;
	                  }
	            }

		  return $doms;

	  }
    
     function greylistingListSave($data,$toDelete){
              if($toDelete){
                 @mysql_query("DELETE from GL_remote_domains");
                 exec('./wrapper "1" "'.DB_FILE_SETTINGS.'" "DELETE from remote_domains"');
                 }
              
              $queryInsert = "INSERT INTO %s (domain,type) VALUES ('%s','%s')";

              while (list($key, $val) = each($data)) {
                      if(eregi("white_",$key) && !empty($val)){
                         
                        if(ereg("([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})",  $val)){
                           $ip = $val;
                           $val = gethostbyaddr($ip); 
			   $ret["w"][$ip] = $val;
                           $ip = null;
                           }

                         $value_mysql = $val;
                         $value_sqllite = str_replace('.', '\.', $val);
                         $value_sqllite = str_replace('*', '.*', $value_sqllite);
                         $qryMysql  = sprintf($queryInsert,'GL_remote_domains',$value_mysql,'white'); 
                         $qrySqlite = sprintf($queryInsert,'remote_domains',$value_sqllite,'white');   
                         exec('./wrapper "1" "'.DB_FILE_SETTINGS.'" "'.$qrySqlite.'"');
                         @mysql_query($qryMysql);
                         }
                      if(eregi("black_",$key) && !empty($val)){

                        if(ereg("([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})",  $val)){
                           $ip = $val;
                           $val = gethostbyaddr($ip); 
			   $ret["b"][$ip] = $val;
                           $ip = null;
                           }

                         $value_mysql = $val;
                         $value_sqllite = str_replace('.', '\.', $val);
                         $value_sqllite = str_replace('*', '.*', $value_sqllite);
                         $qryMysql  = sprintf($queryInsert,'GL_remote_domains',$value_mysql,'black'); 
                         $qrySqlite = sprintf($queryInsert,'remote_domains',$value_sqllite,'black');                      
                         exec('./wrapper "1" "'.DB_FILE_SETTINGS.'" "'.$qrySqlite.'"');
                         @mysql_query($qryMysql);
                         }
                     }  

              return $ret;
	      }

     function printAddedListEntries($data){
              if(count($data["w"])){
                 echo '<br><div class="pass">';
                 while (list($key, $val) = each($data["w"])) {
                 echo sprintf(WHITELISTS_NOTICE_ENTRY,'<u>'.$key.'</u>','<u>'.$val.'</u>');
                 echo '<br>';
                       }
                 echo '</div>';
                 }

              if(count($data["b"])){
                 echo '<br><div class="block">';
                 while (list($key, $val) = each($data["b"])) {
                 echo sprintf(BLACKLISTS_NOTICE_ENTRY,'<u>'.$key.'</u>','<u>'.$val.'</u>');
                 echo '<br>';
                       }
                 echo '</div>';
                 }



             }

     function greylistingListSaveQuite($data){
              if(isset($data["w"])){
                 $newData["white_0"] = gethostbyaddr($data["w"]);
                 $ret = sprintf(WHITELISTS_NOTICE_ENTRY,$data["w"],$newData["white_0"]);
                 }
              if(isset($data["b"])){
                 $newData["black_0"] = gethostbyaddr($data["b"]); 
		 $ret = sprintf(BLACKLISTS_NOTICE_ENTRY,$data["b"],$newData["black_0"]);
                 }
              $this->greylistingListSave($newData,false);
              $this->greylistingList();
              echo(count($this->allLists["white"]).'/'.count($this->allLists["black"])."|".trim($ret));
              exit;

              }
     function greylistingListSavePQuite($data){
              if($data["save_lists_p"] == "w"){
	         $_POST["addwl"] = true;
		 $_POST["wlentry"] = $data["from"];
		 $ret = sprintf(P_WHITELISTS_NOTICE_ENTRY,$data["from"],$data["to"]);
	         }
		 
              if($data["save_lists_p"] == "b"){
	         $_POST["addbl"] = true;
		 $_POST["blentry"] = $data["from"];
		 $ret = sprintf(P_BLACKLISTS_NOTICE_ENTRY,$data["from"],$data["to"]);
	         }		 

    	      $to = explode("@",$data["to"]);
              $_POST["mbox"] = $to[0];
	      
              $this->setUserLists();

              echo $this->userlistsCount["white"].'/'.$this->userlistsCount["black"]."|".trim($ret);
              exit;

              }
              
     function printStat(){
     
              $statData = array();
     
              for($i=0;$i<count($this->mailQueue);$i++){
	          $props = explode("@",$this->mailQueue[$i]["rcptTo"]);
		  if($this->mailQueue[$i]["passCount"] > 0){
		    $statData[$props[1]]["pass"]+=$this->mailQueue[$i]["passCount"];
		    }
		  else{
		    $statData[$props[1]]["block"]+=($this->mailQueue[$i]["blockedCount"]+1);
		  }
	         }
		 
      
              echo '<table width="600" cellpadding="2" cellspacing="0">';
	      echo '<tr>';
	      echo '<td width="175">'.STAT_DOMAIN.'</td>';
	      echo '<td width="150">'.PASSED.'/'.BLOCKED.'</td>';
	      echo '<td width="270">'.STAT_ANTEIL.'</td>';	      
	      echo '</tr>';
              while (list($key, $val) = each($statData)) {
	             echo '<tr>';
		     echo '<td>'.$key.'</td>';
		     $block = (empty($val["block"]))?"0":$val["block"];
		     $pass = (empty($val["pass"]))?"0":$val["pass"];
		     echo '<td>'.$pass.'/'.$block.'</td>';
		     $proz = "0,00";
		     $ps = $block / ($block+$pass) * 100;
	             $proz = str_replace(".",",",round($ps,2));

		     echo '<td align="left" valign="middle">';
		     echo '<div style="float:left;vertical-align:middle"><div style="border:1px inset #CCCCCC;float:left;background:#990000;height:10px;width:'.(round($proz,0)*2).'px"></div>';
		     echo '<div style="float:left">'.$proz.'%</div></div>';		     
		     echo '</td>';
		     echo '</tr>';
	             }
	      
	      echo '</table>';
              }

          
      function sendSpamReport($data){

               if(!$this->plesk_session->chkLevel(IS_ADMIN)){
                   echo "NO RIGHTS TO SEND AN ABUSE MAIL!";
                   exit;
                  }

               $spamline = "==============================================\n";
               $spamline.= "FROM: ".$data["from"]."\n";
               $spamline.= "TO: ".$data["to"]."\n";
               $spamline.= "IP: ".$data["ip"]."\n";
               $spamline.= "TIMESTAMP: ".$data["create"]."\n";
               $spamline.= "==============================================";

               $nachricht = str_replace("{SPAMLINE}",$spamline,$this->glmSettings["abuse"]["template"]);
               $header = 'From: '.$this->glmSettings["abuse"]["sender"]. "\r\n";
               $header.= 'Reply-To: '.$this->glmSettings["abuse"]["sender"]. "\r\n";
               $header.= 'Bcc: '.$this->glmSettings["abuse"]["sender"]. "\r\n";
               $header.= 'GLM[haggybear.de]/X-Mailer: PHP/' . phpversion();
               $isSend = mail($data["rec"], $this->glmSettings["abuse"]["titel"], $nachricht, $header);
               if(!$isSend){
                   echo "ERROR WHILE SENDING THE MAIL!";
                   exit;
                   }
               echo "emailwassend";

               }
               
     function checkForRemoteAccess($val){
     
             
              $isActive = array_key_exists($this->allDoms[0],$this->glmSettings["remote"]);
              
              if((bool)$val["isremoteaccess"] != $isActive){
                 $this->RemoteAccess($val);
                }

              $edit = ($this->glmSettings["remote"]["enabled"]=="true")?true:false;
              
              $select = ($this->glmSettings["remote"][$this->allDoms[0]])?"selected":"";
                                                                          
              if($edit){
                 $token = ($this->glmSettings["remote"][$this->allDoms[0]])?"token:".$this->xtea->Decrypt($this->glmSettings["remote"][$this->allDoms[0]]):VALUE_ACT;
                 echo "<select name=\"isremoteaccess\" onChange=\"document.MailForm.submit()\">\n";
                 echo "<option value=\"0\">".VALUE_DEACT."</option>\n";
                 echo "<option value=\"1\" ".$select.">".$token."</option>\n";
                 echo "</select>";
                }else{
                 echo VALUE_DEACT;
                }
              }
              
     function RemoteAccess($val){
     
              if(!isset($val["isremoteaccess"]))return;
     
              $raid = rand(100000,999999);
                  
              if($val["isremoteaccess"]){
                 $this->glmSettings["remote"][$this->allDoms[0]] = $this->xtea->Encrypt($raid);
              }else{
                 unset($this->glmSettings["remote"][$this->allDoms[0]]);
                 }
              $this->schreibeRemoteSettings();
     
              }
}
?>
