<?php
/*
Plesk FTP User Manager (Version see config.inc.php) - GUI for Plesk FTP User Management

Copyright (C) [2011] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Klasse zum sammeln der User-Rechte der Domain(s)
 */
require("./paa.class.php");

class users extends paa{

      /** Variable, die alle Rechte aus der users.txt aufnimmt */
      var $alleRechte = array();
      
      var $domName = "";
      
      var $isAdm = false;
      
      var $isNoLimit = false;
      
      function __construct($sess,$getVars,$db){
               parent::paa($sess,$getVars["dom_name"],$db);
  	       parent::openDatabase();
	       parent::setPleskSkin();
	       parent::setPleskAllowed(); 
      	       $this->domName = $this->plesk_domain;
      	       $this->readRights();
      	       $this->setNoLimit();
      	       }

      function __destruct(){
               parent::closeDatabase();
               }       	       
      	       
      function setAdm($bool){
      	       $this->isAdm = $bool;
      	       }
      	       
      function readRights(){
      	       $file = fopen("users.txt",'r');
   	       $this->alleRechte = unserialize(trim(fread($file,filesize("users.txt"))));
 	       fclose($file);
      	       }
      	       
      function getAnzFtps(){
      	       $erg = 0;
      	       exec("cat /etc/passwd | grep '/".$this->domName."'", $lines, $result);
      	       for($i=0;$i<count($lines);$i++){
      	       	   if(!stristr($lines[$i],"web_users"))$erg++;
      	       	   }
      	       //return (count($lines)-1);
      	       return $erg;
      	       }
      	       
      function setNoLimit(){
      	       
      	       $this->isNoLimit = (!array_key_exists($this->domName,$this->alleRechte) || $this->alleRechte[$this->domName] == -1)?true:false;
      	     
      	       }
      
      function getMaxUser(){
      	
      	       $html = "";
      	
      	       if($this->isNoLimit){
      	       	  $html = "&infin;";
      	       	  $dis = "disabled style=\"background:#D4D0C8\"";
      	       	  
      	          }
      	       else{
      	          $html = $this->alleRechte[$this->domName];
      	          $dis = "";
      	          }
      	
      	
      	       if($this->isAdm){
      	       	  echo '<input onfocus="this.value=\'\';document.getElementById(\'nolimitftp\').checked=false" onkeyup="return validate(this)" type="text" size="2" id="maxuser" class="rounded_input" name="maxuser" value="'.$html.'" '.$dis.'>';
      	       	  }
      	       else{
      	          echo "<span style=\"font-size:12px\">$html</a>";
      	          }
      	
      	       }	       
      
      function setMaxUser($POST){
      	
      	       $ret = "";
      	
      	       if(isset($POST["nolimitftp"])){
      	       	  $max = -1;
      	       	  $this->isNoLimit = true;
      	       	  }
      	       else{
      	          $max = (empty($POST["maxuser"]) || !is_numeric($POST["maxuser"]))?0:$POST["maxuser"];
      	          if($max < $this->getAnzFtps()){
      	             $ret = "PFTP_ANZ_USER_TOO_LOW";
      	             return $ret;	
      	             }
      	          
      	          $this->isNoLimit = false;
      	          }
      	          
      	       $this->alleRechte[$this->domName] = $max;
               $this->alleRechte[$this->domName."_shell"] = $POST["shell_access"];
      	       
      	       $this->writeRights();
      	       
      	       return $ret;
      	
      	       }

      function getShellAccess(){
               if($this->alleRechte[$this->domName."_shell"] == 1) return true;

               return false;


               }
       
      function writeRights(){
               $write = serialize($this->alleRechte);
               $openStream = fopen ("users.txt","w");
	       fwrite($openStream,$write,strlen($write)); 
               fclose($openStream);
               }
               
      function getMaxUserCount(){
      	
      	       if($this->isNoLimit) return 9999999;
      	       
      	       return $this->alleRechte[$this->domName];
      	
      	       }               
               
      function allowMore(){
      	
      	       if($this->isNoLimit || $this->alleRechte[$this->domName] > $this->getAnzFtps()) return true;
      	       
      	       return false;
      	
      	       }





}